@replaceMethod(PhoneCallUploadDurationListener)
  protected cb func OnStatPoolMaxValueReached(value: Float) -> Bool {
    if Equals(this.m_statPoolType, gamedataStatPoolType.CallReinforcementProgress) {
	
	  if !GetPlayer(this.m_gameInstance).IsInCombat(){
	    this.SendUploadFinishedEvent();
		this.UnregisterListener();
	  };
	  
	  //Removing this line enables same puppet to make multiple calls
      //this.m_requesterPuppet.GetPuppetStateBlackboard().SetBool(GetAllBlackboardDefs().PuppetState.HasCalledReinforcements, true);
	  
	  //Might come into use later
	  let affiliation: String = ToString((this.m_requesterPuppet as NPCPuppet).GetAffiliation());
	  let playerStreetCred: Int32 = RoundF(GameInstance.GetStatsSystem(this.m_gameInstance).GetStatValue(Cast(GetPlayer(this.m_gameInstance).GetEntityID()), gamedataStatType.StreetCred));

	  //Trigger the prevention system on a call, but only if player is in combat
	  if GetPlayer(this.m_gameInstance).IsInCombat(){
			PreventionSystem.CreateNewDamageRequest(this.m_gameInstance, GetPlayer(this.m_gameInstance), 1.00);
		};
    };
    this.SendUploadFinishedEvent();
    this.UnregisterListener();
  }

@replaceMethod(AISubActionCallReinforcements_Record_Implementation)
  public final static func StartCallReinforcement(context: ScriptExecutionContext, record: wref<AISubActionCallReinforcements_Record>) -> Void {
    let m_pauseResumePhoneCallEvent: ref<PauseResumePhoneCallEvent>;
    let m_startPhoneCallEvent: ref<StartEndPhoneCallEvent>;
    let m_statPoolType: gamedataStatPoolType = gamedataStatPoolType.CallReinforcementProgress;
    let m_puppet: wref<ScriptedPuppet> = ScriptExecutionContext.GetOwner(context) as ScriptedPuppet;
    let m_statPoolsSystem: ref<StatPoolsSystem> = GameInstance.GetStatPoolsSystem(ScriptExecutionContext.GetOwner(context).GetGame());
	
	//Check if no one else is calling for backup
	let squadMembers: array<wref<Entity>>;
	AISquadHelper.GetSquadmates(m_puppet, squadMembers);
	let i: Int32 = 0;
	while i<ArraySize(squadMembers){
		if m_statPoolsSystem.GetStatPoolValue(Cast(squadMembers[i].GetEntityID()), gamedataStatPoolType.CallReinforcementProgress, false) > 0.00{
			return;
		};
		i = i + 1;
	};
	
	let preventionMembers: array<wref<ScriptedPuppet>> = m_puppet.GetPreventionSystem().GetSpawnedAgents();
	i = 0;
	while i<ArraySize(preventionMembers){
		if m_statPoolsSystem.GetStatPoolValue(Cast(preventionMembers[i].GetEntityID()), gamedataStatPoolType.CallReinforcementProgress, false) > 0.00{
			return;
		};
		i = i + 1;
	};
	//Don't call if we're at max heat already
	if Equals(m_puppet.GetPreventionSystem().GetHeatStage(), EPreventionHeatStage.Heat_4){
		return;
	};
	
	//Don't call if prevention is locked
	if m_puppet.GetPreventionSystem().IsPreventionInputLocked(){
		return;
	};
	
	//Check if the player is not the target
	if !(m_puppet as NPCPuppet).m_isTargetingPlayer{
		return;
	};
	
	//Check if NPC is ragdolling
	if (m_puppet as NPCPuppet).m_isRagdolling{
		return;
	};   

	//Check some cases
	if StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.Stunned) ||
	StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.EMP) ||
	StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.Grapple) ||
	StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.Knockdown) ||
	StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.SuicideHack) ||
	StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.Madness) ||
	StatusEffectSystem.ObjectHasStatusEffectOfType(m_puppet, gamedataStatusEffectType.SystemCollapse) ||
	StatusEffectSystem.ObjectHasStatusEffectWithTag(m_puppet, n"CommsNoiseJam")
	{
		return;
	};
	

	
	if !m_statPoolsSystem.IsStatPoolAdded(Cast(m_puppet.GetEntityID()), m_statPoolType) {
      m_startPhoneCallEvent = new StartEndPhoneCallEvent();
      m_startPhoneCallEvent.callDuration = record.Duration();
      m_startPhoneCallEvent.startCall = true;
      m_startPhoneCallEvent.statType = gamedataStatType.CallReinforcement;
      m_startPhoneCallEvent.statPoolType = gamedataStatPoolType.CallReinforcementProgress;
      m_startPhoneCallEvent.statPoolName = "BaseStatPools.CallReinforcementProgress";
      m_puppet.QueueEvent(m_startPhoneCallEvent);
    } else {
      m_pauseResumePhoneCallEvent = new PauseResumePhoneCallEvent();
      m_pauseResumePhoneCallEvent.callDuration = record.Duration();
      m_pauseResumePhoneCallEvent.pauseCall = false;
      m_pauseResumePhoneCallEvent.statPoolType = m_statPoolType;
      m_puppet.QueueEvent(m_pauseResumePhoneCallEvent);
    };
  }

@addMethod(PreventionSystem)
public func GetSpawnedAgents() -> array<wref<ScriptedPuppet>>{
	return this.m_spawnedAgents;
}

//Implement quickhacking to stop call mechanics
@wrapMethod(NPCPuppet)
  private final func OnQuickHackEffectApplied(evt: ref<ApplyStatusEffectEvent>) -> Void {
  
    let gmplTags: array<CName> = evt.staticData.GameplayTags();
	
	    if ArrayContains(gmplTags, n"SquadMemoryWipe")
			|| ArrayContains(gmplTags, n"CommsNoise")
			|| ArrayContains(gmplTags, n"Madness")
			|| ArrayContains(gmplTags, n"SuicideWithWeapon")
			|| ArrayContains(gmplTags, n"SuicideWithGrenade")
			|| ArrayContains(gmplTags, n"SystemCollapse")
			|| GameInstance.GetStatsSystem(this.GetGame()).GetStatValue(Cast(evt.instigatorEntityID), gamedataStatType.CommsNoiseJamOnQuickhack) == 1.00 {
			GameInstance.GetStatPoolsSystem(this.GetGame()).RequestRemovingStatPool(Cast(this.GetEntityID()), gamedataStatPoolType.CallReinforcementProgress);
      };
	  wrappedMethod(evt);
  }
  
//Remove call if ragdolling
@wrapMethod(NPCPuppet)
  protected cb func OnRagdollEnabledEvent(evt: ref<RagdollNotifyEnabledEvent>) -> Bool {
			GameInstance.GetStatPoolsSystem(this.GetGame()).RequestRemovingStatPool(Cast(this.GetEntityID()), gamedataStatPoolType.CallReinforcementProgress);
			wrappedMethod(evt);
  }
  
//Remove call if EMP, grapple, knockdown, and stun
@wrapMethod(NPCPuppet)
  protected cb func OnStatusEffectApplied(evt: ref<ApplyStatusEffectEvent>) -> Bool {
	
	let type: wref<StatusEffectType_Record> = evt.staticData.StatusEffectType();
    if Equals(type, gamedataStatusEffectType.Stunned) ||
		Equals(type, gamedataStatusEffectType.EMP) ||
		Equals(type, gamedataStatusEffectType.Grapple) ||
		Equals(type, gamedataStatusEffectType.Knockdown){
		GameInstance.GetStatPoolsSystem(this.GetGame()).RequestRemovingStatPool(Cast(this.GetEntityID()), gamedataStatPoolType.CallReinforcementProgress);
    };
	wrappedMethod(evt);
  }